/* HOUSEHOLD VEHICLE OWNERSHIP PROJECTION MODEL*/
/* This model makes use of.. */
/* (1] MODEL results from.. */
/*   (a) Population projections */
/*   (b) Income growth projections*/
/* (2] EXOGENOUS probabilities of vehicle holdings by region and HH Living arrangement type*/
/*    with */
/*   (a) census data (historical) with trends interpolated */
/*   (b) income elasticity paramaters calibrated using a binary (GLM) model*/
/*   (c) and region specific density parameters from the same GLM model where these were significant. */
/* */
mata
/* DIMENSIONS*/
/*Projection length, periods*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050*/
/*Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection*/
/*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length

*Length of history*/
*History_length = length(History_t) */
History_length = Te - Ts+1
HL = History_length

/*Length of projection*/
/*Projection_length = length(Projection_t) */
Projection_length = Pe - Ps + 1

/*Last year for which census HH income data available*/
LastCensusYear = 2020

/*Set number of age groups and variable for k-1 (ages) */
AgesV = 0..90
k_minus_one = length(AgesV)-1
/*Set Household Living arrangement types (LATRs) */
LATR_n = (1..11)

LATR_str =("onep_c" , "twop_c" , "alon_a",  "mult_o", "cple_o", "onep_o", "twop_o", "onep_a", "cple_a", "twop_a", "nonprv")
HH_str =("alone" , "onep" , "twop" , "multif" , "multi" , "cple")

/* Set number of vehicles per HH*/
veh_per_hh = (0,1,2,3) 
veh_per_hh_n = cols(veh_per_hh)
/* set number of regions*/
Regions = 1..12
Regions_n = length(Regions)
Regl = 12
/*lfpr age bands*/
lfpr_bands = 1..11 
lfpr_bands_n = length(lfpr_bands)

/* PARAMETERS*/
/* (1] NZ Land area (complement to the regional land areas in the data*/
/* (2] Vehicle number per household probability parameters*/
/*  Model is VEH_P| VEH_P=x = (e^x.Beta)/(1:+e^x.Beta) */
/*  Coeffs [in input data) in partitioned matrix (partitioned by HH type by rows) i.e. */
/*  veh_p_beta(hhtype,.] = k x veh_per_hh_n*/
NZ_area = 15524622.00 
veh_model_k = 5



/* INITIALISE*/
/* (a) Empty vehicle matrices for hh vehicle ownership (t, n) n = veh_per_hh*/
/* (b) Regional vehicles*/

alon_veh_n_fit = J(Time_length,length(veh_per_hh), 0)
cple_veh_n_fit = J(Time_length,length(veh_per_hh), 0)
multi_veh_n_fit = J(Time_length,length(veh_per_hh), 0)
multif_veh_n_fit = J(Time_length,length(veh_per_hh), 0)
onep_veh_n_fit = J(Time_length,length(veh_per_hh), 0)
twop_veh_n_fit = J(Time_length,length(veh_per_hh), 0)
reg_dens = J(Time_length, Regl, 0)
alon_veh_p_i = J(Time_length,veh_per_hh_n, 0)
/*alon_veh_p = (alon_veh_p(1..20,.]\J(Projection_length, veh_per_hh_n, 0)) */
/*Log model fitted probabilities*/
alon_p_fit_i = (nz_veh_p[.,1..4]\J((TL-HL), veh_per_hh_n, 0)) 
cple_p_fit_i = (nz_veh_p[.,5..8]\J((TL-HL), veh_per_hh_n, 0)) 
mult_p_fit_i = (nz_veh_p[.,9..12]\J((TL-HL), veh_per_hh_n, 0)) 
multif_p_fit_i = (nz_veh_p[.,13..16]\J((TL-HL), veh_per_hh_n, 0)) 
onep_p_fit_i = (nz_veh_p[.,17..20]\J((TL-HL), veh_per_hh_n, 0)) 
twop_p_fit_i = (nz_veh_p[.,21..24]\J((TL-HL), veh_per_hh_n, 0)) 
/*Model fitted probabilities*/
alon_p_fit = (nz_veh_p[.,1..4]\J((TL-HL), veh_per_hh_n, 0)) 
cple_p_fit = (nz_veh_p[.,5..8]\J((TL-HL), veh_per_hh_n, 0)) 
mult_p_fit = (nz_veh_p[.,9..12]\J((TL-HL), veh_per_hh_n, 0)) 
multif_p_fit = (nz_veh_p[.,13..16]\J((TL-HL), veh_per_hh_n, 0)) 
onep_p_fit = (nz_veh_p[.,17..20]\J((TL-HL), veh_per_hh_n, 0)) 
twop_p_fit = (nz_veh_p[.,21..24]\J((TL-HL), veh_per_hh_n, 0)) 
alon_p_hist = (nz_veh_p[.,1..4]\J((TL-HL), veh_per_hh_n, 0)) 
cple_p_hist = (nz_veh_p[.,5..8]\J((TL-HL), veh_per_hh_n, 0)) 
mult_p_hist = (nz_veh_p[.,9..12]\J((TL-HL), veh_per_hh_n, 0)) 
multif_p_hist = (nz_veh_p[.,13..16]\J((TL-HL), veh_per_hh_n, 0)) 
onep_p_hist = (nz_veh_p[.,17..20]\J((TL-HL), veh_per_hh_n, 0)) 
twop_p_hist = (nz_veh_p[.,21..24]\J((TL-HL), veh_per_hh_n, 0)) 


/*Regional matrices*/
wel_dum = J(Time_length,Regl, 0)
wel_dum[.,7]= J(Time_length,1, 1)


alon_exog_reg = J(Time_length,veh_model_k*Regl, 0)
cple_exog_reg = J(Time_length,veh_model_k*Regl, 0)
mult_exog_reg = J(Time_length,veh_model_k*Regl, 0)
multif_exog_reg = J(Time_length,veh_model_k*Regl, 0)
onep_exog_reg = J(Time_length,veh_model_k*Regl, 0)
twop_exog_reg = J(Time_length,veh_model_k*Regl, 0)

alon_p_reg_i = J(Regl*Time_length,veh_per_hh_n, 0)
cple_p_reg_i = J(Regl*Time_length,veh_per_hh_n, 0)
mult_p_reg_i = J(Regl*Time_length,veh_per_hh_n, 0)
multif_p_reg_i = J(Regl*Time_length,veh_per_hh_n, 0)
onep_p_reg_i = J(Regl*Time_length,veh_per_hh_n, 0)
twop_p_reg_i = J(Regl*Time_length,veh_per_hh_n, 0)

alon_p_reg_fit = J(Regl*Time_length,veh_per_hh_n, 0)
cple_p_reg_fit = J(Regl*Time_length,veh_per_hh_n, 0)
mult_p_reg_fit = J(Regl*Time_length,veh_per_hh_n, 0)
multif_p_reg_fit = J(Regl*Time_length,veh_per_hh_n, 0)
onep_p_reg_fit = J(Regl*Time_length,veh_per_hh_n, 0)
twop_p_reg_fit = J(Regl*Time_length,veh_per_hh_n, 0)

alon_p_reg_hist =  J(Regl*Time_length,veh_per_hh_n, 0)
cple_p_reg_hist =  J(Regl*Time_length,veh_per_hh_n, 0)
mult_p_reg_hist =  J(Regl*Time_length,veh_per_hh_n, 0)
multif_p_reg_hist =  J(Regl*Time_length,veh_per_hh_n, 0)
onep_p_reg_hist =  J(Regl*Time_length,veh_per_hh_n, 0)
twop_p_reg_hist =  J(Regl*Time_length,veh_per_hh_n, 0)

alon_veh_reg_n_fit = J(Regl*Time_length,veh_per_hh_n, 0)
cple_veh_reg_n_fit = J(Regl*Time_length,veh_per_hh_n, 0)
multi_veh_reg_n_fit = J(Regl*Time_length,veh_per_hh_n, 0)
multif_veh_reg_n_fit = J(Regl*Time_length,veh_per_hh_n, 0)
onep_veh_reg_n_fit = J(Regl*Time_length,veh_per_hh_n, 0)
twop_veh_reg_n_fit = J(Regl*Time_length,veh_per_hh_n, 0)

alon_veh_reg_n = J(Regl*Time_length,veh_per_hh_n, 0)
cple_veh_reg_n = J(Regl*Time_length,veh_per_hh_n, 0)
multi_veh_reg_n = J(Regl*Time_length,veh_per_hh_n, 0)
multif_veh_reg_n = J(Regl*Time_length,veh_per_hh_n, 0)
onep_veh_reg_n = J(Regl*Time_length,veh_per_hh_n, 0)
twop_veh_reg_n = J(Regl*Time_length,veh_per_hh_n, 0)


alon_veh_reg = J(Time_length,1*Regl, 0)
cple_veh_reg = J(Time_length,1*Regl, 0)
multi_veh_reg = J(Time_length,1*Regl, 0)
multif_veh_reg = J(Time_length,1*Regl, 0)
onep_veh_reg = J(Time_length,1*Regl, 0)
twop_veh_reg = J(Time_length,1*Regl, 0)


/*Populate probability matrices with input data */

for (i=1; i<=Regl; i++){
alon_p_reg_i[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,1..4]\J((TL-HL),veh_per_hh_n,0 ))
cple_p_reg_i[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,5..8]\J((TL-HL),veh_per_hh_n, 0))
mult_p_reg_i[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,9..12]\J((TL-HL),veh_per_hh_n, 0))
multif_p_reg_i[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,13..16]\J((TL-HL),veh_per_hh_n, 0))
onep_p_reg_i[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,17..20]\J((TL-HL),veh_per_hh_n, 0))
twop_p_reg_i[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,21..24]\J((TL-HL),veh_per_hh_n, 0))
alon_p_reg_fit[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,1..4]\J((TL-HL),veh_per_hh_n, 0))
cple_p_reg_fit[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,5..8]\J((TL-HL),veh_per_hh_n, 0))
mult_p_reg_fit[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,9..12]\J((TL-HL),veh_per_hh_n, 0))
multif_p_reg_fit[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,13..16]\J((TL-HL),veh_per_hh_n, 0))
onep_p_reg_fit[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,17..20]\J((TL-HL),veh_per_hh_n, 0))
twop_p_reg_fit[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,21..24]\J((TL-HL),veh_per_hh_n, 0))
alon_p_reg_hist[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,1..4]\J((TL-HL),veh_per_hh_n, 0))
cple_p_reg_hist[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,5..8]\J((TL-HL),veh_per_hh_n, 0))
mult_p_reg_hist[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,9..12]\J((TL-HL),veh_per_hh_n, 0))
multif_p_reg_hist[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,13..16]\J((TL-HL),veh_per_hh_n, 0))
onep_p_reg_hist[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,17..20]\J((TL-HL),veh_per_hh_n, 0))
twop_p_reg_hist[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,21..24]\J((TL-HL),veh_per_hh_n, 0))
alon_veh_reg_n[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,1..4]\J((TL-HL),veh_per_hh_n, 0))
cple_veh_reg_n[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,5..8]\J((TL-HL),veh_per_hh_n, 0))
multi_veh_reg_n[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,9..12]\J((TL-HL),veh_per_hh_n, 0))
multif_veh_reg_n[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,13..16]\J((TL-HL),veh_per_hh_n, 0))
onep_veh_reg_n[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,17..20]\J((TL-HL),veh_per_hh_n, 0))
twop_veh_reg_n[(i-1)*TL+1..i*TL,.] = (reg_veh_p[(i-1)*HL+1..i*HL,21..24]\J((TL-HL),veh_per_hh_n, 0))
}


/*Precalculating number of households in each vehicle holding category -*/
/*from input data*/

for (i=1; i<=Regl; i++) {
    alon_veh_reg_n[(i-1)*TL+1..i*TL,1] = alon_reg[.,i]:*alon_veh_reg_n[(i-1)*TL+1..i*TL,1]
    alon_veh_reg_n[(i-1)*TL+1..i*TL,2] = alon_reg[.,i]:*alon_veh_reg_n[(i-1)*TL+1..i*TL,2]
    alon_veh_reg_n[(i-1)*TL+1..i*TL,3] = alon_veh_reg_n[(i-1)*TL+1..i*TL,2]:*alon_veh_reg_n[(i-1)*TL+1..i*TL,3]
    alon_veh_reg_n[(i-1)*TL+1..i*TL,4] = alon_veh_reg_n[(i-1)*TL+1..i*TL,3]:*alon_veh_reg_n[(i-1)*TL+1..i*TL,4]
    alon_veh_reg_n[(i-1)*TL+1..i*TL,3] = alon_veh_reg_n[(i-1)*TL+1..i*TL,3] - alon_veh_reg_n[(i-1)*TL+1..i*TL,4]
    alon_veh_reg_n[(i-1)*TL+1..i*TL,2] = alon_veh_reg_n[(i-1)*TL+1..i*TL,2] - (alon_veh_reg_n[(i-1)*TL+1..i*TL,3]+ alon_veh_reg_n[(i-1)*TL+1..i*TL,4])
   
    cple_veh_reg_n[(i-1)*TL+1..i*TL,1] = cple_reg[.,i]:*cple_veh_reg_n[(i-1)*TL+1..i*TL,1]
    cple_veh_reg_n[(i-1)*TL+1..i*TL,2] = cple_reg[.,i]:*cple_veh_reg_n[(i-1)*TL+1..i*TL,2]
    cple_veh_reg_n[(i-1)*TL+1..i*TL,3] = cple_veh_reg_n[(i-1)*TL+1..i*TL,2]:*cple_veh_reg_n[(i-1)*TL+1..i*TL,3]
    cple_veh_reg_n[(i-1)*TL+1..i*TL,4] = cple_veh_reg_n[(i-1)*TL+1..i*TL,3]:*cple_veh_reg_n[(i-1)*TL+1..i*TL,4]   
    cple_veh_reg_n[(i-1)*TL+1..i*TL,3] = cple_veh_reg_n[(i-1)*TL+1..i*TL,3] - cple_veh_reg_n[(i-1)*TL+1..i*TL,4]
    cple_veh_reg_n[(i-1)*TL+1..i*TL,2] = cple_veh_reg_n[(i-1)*TL+1..i*TL,2] - (cple_veh_reg_n[(i-1)*TL+1..i*TL,3]+ cple_veh_reg_n[(i-1)*TL+1..i*TL,4])
    
    multi_veh_reg_n[(i-1)*TL+1..i*TL,1] = multi_reg[.,i]:*multi_veh_reg_n[(i-1)*TL+1..i*TL,1]
    multi_veh_reg_n[(i-1)*TL+1..i*TL,2] = multi_reg[.,i]:*multi_veh_reg_n[(i-1)*TL+1..i*TL,2]
    multi_veh_reg_n[(i-1)*TL+1..i*TL,3] = multi_veh_reg_n[(i-1)*TL+1..i*TL,2]:*multi_veh_reg_n[(i-1)*TL+1..i*TL,3]
    multi_veh_reg_n[(i-1)*TL+1..i*TL,3] = multi_veh_reg_n[(i-1)*TL+1..i*TL,3] - multi_veh_reg_n[(i-1)*TL+1..i*TL,4]
    multi_veh_reg_n[(i-1)*TL+1..i*TL,2] = multi_veh_reg_n[(i-1)*TL+1..i*TL,2] - (multi_veh_reg_n[(i-1)*TL+1..i*TL,3]+ multi_veh_reg_n[(i-1)*TL+1..i*TL,4])
    
    multif_veh_reg_n[(i-1)*TL+1..i*TL,1] = multif_reg[.,i]:*multif_veh_reg_n[(i-1)*TL+1..i*TL,1]
    multif_veh_reg_n[(i-1)*TL+1..i*TL,2] = multif_reg[.,i]:*multif_veh_reg_n[(i-1)*TL+1..i*TL,2]
    multif_veh_reg_n[(i-1)*TL+1..i*TL,3] = multif_veh_reg_n[(i-1)*TL+1..i*TL,2]:*multif_veh_reg_n[(i-1)*TL+1..i*TL,3]
    multif_veh_reg_n[(i-1)*TL+1..i*TL,4] = multif_veh_reg_n[(i-1)*TL+1..i*TL,3]:*multif_veh_reg_n[(i-1)*TL+1..i*TL,4]
    multif_veh_reg_n[(i-1)*TL+1..i*TL,3] = multif_veh_reg_n[(i-1)*TL+1..i*TL,3] - multif_veh_reg_n[(i-1)*TL+1..i*TL,4]
    multif_veh_reg_n[(i-1)*TL+1..i*TL,2] = multif_veh_reg_n[(i-1)*TL+1..i*TL,2] - (multif_veh_reg_n[(i-1)*TL+1..i*TL,3]+ multif_veh_reg_n[(i-1)*TL+1..i*TL,4])    
    
    onep_veh_reg_n[(i-1)*TL+1..i*TL,1] = onep_reg[.,i]:*onep_veh_reg_n[(i-1)*TL+1..i*TL,1]
    onep_veh_reg_n[(i-1)*TL+1..i*TL,2] = onep_reg[.,i]:*onep_veh_reg_n[(i-1)*TL+1..i*TL,2]
    onep_veh_reg_n[(i-1)*TL+1..i*TL,3] = onep_veh_reg_n[(i-1)*TL+1..i*TL,2]:*onep_veh_reg_n[(i-1)*TL+1..i*TL,3]
    onep_veh_reg_n[(i-1)*TL+1..i*TL,4] = onep_veh_reg_n[(i-1)*TL+1..i*TL,3]:*onep_veh_reg_n[(i-1)*TL+1..i*TL,4]
    onep_veh_reg_n[(i-1)*TL+1..i*TL,3] = onep_veh_reg_n[(i-1)*TL+1..i*TL,3] - onep_veh_reg_n[(i-1)*TL+1..i*TL,4]
    onep_veh_reg_n[(i-1)*TL+1..i*TL,2] = onep_veh_reg_n[(i-1)*TL+1..i*TL,2] - (onep_veh_reg_n[(i-1)*TL+1..i*TL,3]+ onep_veh_reg_n[(i-1)*TL+1..i*TL,4])
    
    twop_veh_reg_n[(i-1)*TL+1..i*TL,1] = twop_reg[.,i]:*twop_veh_reg_n[(i-1)*TL+1..i*TL,1]
    twop_veh_reg_n[(i-1)*TL+1..i*TL,2] = twop_reg[.,i]:*twop_veh_reg_n[(i-1)*TL+1..i*TL,2]
    twop_veh_reg_n[(i-1)*TL+1..i*TL,3] = twop_veh_reg_n[(i-1)*TL+1..i*TL,2]:*twop_veh_reg_n[(i-1)*TL+1..i*TL,3]
    twop_veh_reg_n[(i-1)*TL+1..i*TL,4] = twop_veh_reg_n[(i-1)*TL+1..i*TL,3]:*twop_veh_reg_n[(i-1)*TL+1..i*TL,4]
    twop_veh_reg_n[(i-1)*TL+1..i*TL,3] = twop_veh_reg_n[(i-1)*TL+1..i*TL,3] - twop_veh_reg_n[(i-1)*TL+1..i*TL,4]
    twop_veh_reg_n[(i-1)*TL+1..i*TL,2] = twop_veh_reg_n[(i-1)*TL+1..i*TL,2] - (twop_veh_reg_n[(i-1)*TL+1..i*TL,3]+ twop_veh_reg_n[(i-1)*TL+1..i*TL,4])
}

/* PROJECT HOUSEHOLD VEHICLE HOLDINGS*/
/* Project HH propensity (_veh_p) to hold a vehicle - for each category of*/
/* holding. */
/* [i] Calculate relevant densities*/


nz_dens = (pop:/NZ_area)*100
for (i=1; i<=Regl; i++) {
    reg_dens[.,i] = (pop_by_reg[.,i]/Area[i,.])*100
}

/*[ii]Create exogenous matrices*/
/*(a) NZ total*/
alon_exog = (J(TL,1,1),alon_inc,J(TL,1,0),nz_dens,alon_age)
cple_exog = (J(TL,1,1),cple_inc,J(TL,1,0),nz_dens,cple_age)
mult_exog = (J(TL,1,1),mult_inc,J(TL,1,0),nz_dens,mult_age)
multif_exog = (J(TL,1,1),multif_inc,J(TL,1,0),nz_dens,multif_age)
onep_exog = (J(TL,1,1),onep_inc,J(TL,1,0),nz_dens,onep_age)
twop_exog = (J(TL,1,1),twop_inc,J(TL,1,0),nz_dens,twop_age)


/*(b) Regional Multidimensional array TxHHxReg*/
for (i=1; i<=Regl; i++) {
alon_exog_reg[.,(i-1)*5+1..i*5] = (J(TL,1,1),alon_inc_reg[.,i],wel_dum[.,i],reg_dens[.,i],alon_age) 
cple_exog_reg[.,(i-1)*5+1..i*5] = (J(TL,1,1),cple_inc_reg[.,i],wel_dum[.,i],reg_dens[.,i],cple_age) 
mult_exog_reg[.,(i-1)*5+1..i*5] = (J(TL,1,1),mult_inc_reg[.,i],wel_dum[.,i],reg_dens[.,i],mult_age) 
multif_exog_reg[.,(i-1)*5+1..i*5] = (J(TL,1,1),multif_inc_reg[.,i],wel_dum[.,i],reg_dens[.,i],multif_age) 
onep_exog_reg[.,(i-1)*5+1..i*5] = (J(TL,1,1),onep_inc_reg[.,i],wel_dum[.,i],reg_dens[.,i],onep_age) 
twop_exog_reg[.,(i-1)*5+1..i*5] = (J(TL,1,1),twop_inc_reg[.,i],wel_dum[.,i],reg_dens[.,i],twop_age) 
}


/* [iii] Extract Model Coefficients*/
alon_p_beta = veh_p_beta[1..5,.]
cple_p_beta = veh_p_beta[6..10,.]
mult_p_beta = veh_p_beta[11..15,.]
multif_p_beta = veh_p_beta[16..20,.]
onep_p_beta = veh_p_beta[21..25,.]
twop_p_beta = veh_p_beta[26..30,.]

alon_p_beta_reg = J(1, 12, alon_p_beta)
cple_p_beta_reg = J(1, 12, cple_p_beta)
mult_p_beta_reg = J(1, 12, mult_p_beta)
multif_p_beta_reg = J(1, 12, multif_p_beta)
onep_p_beta_reg = J(1, 12, onep_p_beta)
twop_p_beta_reg = J(1, 12, twop_p_beta)

veh_per_hh_reg = J(12, 1, veh_per_hh')


/* (iv) Estimate initial log model fit*/
/*(a) NZ Total */
for (i=2; i<=4; i++) {
    alon_p_fit_i[.,i]=alon_exog[.,.]*alon_p_beta[.,i-1]
    cple_p_fit_i[.,i]=cple_exog[.,.]*cple_p_beta[.,i-1]
    mult_p_fit_i[.,i]=mult_exog[.,.]*mult_p_beta[.,i-1]
    multif_p_fit_i[.,i]=multif_exog[.,.]*multif_p_beta[.,i-1]
    onep_p_fit_i[.,i]=onep_exog[.,.]*onep_p_beta[.,i-1]
    twop_p_fit_i[.,i]=twop_exog[.,.]*twop_p_beta[.,i-1]
}

/*(b) Regional*/
for (i=2; i<=4; i++) {
    for (j=1; j<=Regl; j++){
    alon_p_reg_i[(j-1)*TL+1..j*TL,i]= alon_exog_reg[.,(j-1)*5+1..j*5]*alon_p_beta_reg[.,(j-1)*3+(i-1)]
    cple_p_reg_i[(j-1)*TL+1..j*TL,i]= cple_exog_reg[.,(j-1)*5+1..j*5]*cple_p_beta_reg[.,(j-1)*3+(i-1)]
    mult_p_reg_i[(j-1)*TL+1..j*TL,i]= mult_exog_reg[.,(j-1)*5+1..j*5]*mult_p_beta_reg[.,(j-1)*3+(i-1)]
    multif_p_reg_i[(j-1)*TL+1..j*TL,i]= multif_exog_reg[.,(j-1)*5+1..j*5]*multif_p_beta_reg[.,(j-1)*3+(i-1)]
    onep_p_reg_i[(j-1)*TL+1..j*TL,i]= onep_exog_reg[.,(j-1)*5+1..j*5]*onep_p_beta_reg[.,(j-1)*3+(i-1)]
    twop_p_reg_i[(j-1)*TL+1..j*TL,i]= twop_exog_reg[.,(j-1)*5+1..j*5]*twop_p_beta_reg[.,(j-1)*3+(i-1)]
}
}


/* (v) Calculate fitted probabilities*/
/*(a) NZ Total*/
alon_p_fit[.,.] = exp(alon_p_fit_i[.,.]):/(1:+exp(alon_p_fit_i[.,.]))
cple_p_fit[.,.] = exp(cple_p_fit_i[.,.]):/(1:+exp(cple_p_fit_i[.,.]))
mult_p_fit[.,.] = exp(mult_p_fit_i[.,.]):/(1:+exp(mult_p_fit_i[.,.]))
multif_p_fit[.,.] = exp(multif_p_fit_i[.,.]):/(1:+exp(multif_p_fit_i[.,.]))
onep_p_fit[.,.] = exp(onep_p_fit_i[.,.]):/(1:+exp(onep_p_fit_i[.,.]))
twop_p_fit[.,.] = exp(twop_p_fit_i[.,.]):/(1:+exp(twop_p_fit_i[.,.]))

alon_p_ind = alon_p_fit:/J(TL,1,alon_p_fit[HL,.]) 
cple_p_ind = cple_p_fit:/J(TL,1,cple_p_fit[HL,.])
mult_p_ind = mult_p_fit:/J(TL,1,mult_p_fit[HL,.])
multif_p_ind = multif_p_fit:/J(TL,1,multif_p_fit[HL,.])
onep_p_ind = onep_p_fit:/J(TL,1,onep_p_fit[HL,.])
twop_p_ind = twop_p_fit:/J(TL,1,twop_p_fit[HL,.])

alon_p_fit[.,.] =  (alon_p_hist[1..HL,.]\alon_p_ind[HL+1..rows(alon_p_ind),.])
cple_p_fit[.,.] =  (cple_p_hist[1..HL,.]\cple_p_ind[HL+1..rows(cple_p_ind),.])
mult_p_fit[.,.] =  (mult_p_hist[1..HL,.]\mult_p_ind[HL+1..rows(mult_p_ind),.])
multif_p_fit[.,.] = (multif_p_hist[1..HL,.]\multif_p_ind[HL+1..rows(multif_p_ind),.])
onep_p_fit[.,.] =  (onep_p_hist[1..HL,.]\onep_p_ind[HL+1..rows(onep_p_ind),.])
twop_p_fit[.,.] =  (twop_p_hist[1..HL,.]\twop_p_ind[HL+1..rows(onep_p_ind),.])

for (i=HL+1; i<=TL; i++) {
    alon_p_fit[i,.] = alon_p_fit[HL,.]:*alon_p_ind[i,.]
    cple_p_fit[i,.] = cple_p_fit[HL,.]:*cple_p_ind[i,.]
    mult_p_fit[i,.] = mult_p_fit[HL,.]:*mult_p_ind[i,.]
    multif_p_fit[i,.] = multif_p_fit[HL,.]:*multif_p_ind[i,.]
    onep_p_fit[i,.] = onep_p_fit[HL,.]:*onep_p_ind[i,.]
    twop_p_fit[i,.] = twop_p_fit[HL,.]:*twop_p_ind[i,.]
}


/*(b) Regional*/
alon_p_reg_fit = exp(alon_p_reg_i):/(1:+exp(alon_p_reg_i))
cple_p_reg_fit = exp(cple_p_reg_i):/(1:+exp(cple_p_reg_i))
mult_p_reg_fit = exp(mult_p_reg_i):/(1:+exp(mult_p_reg_i))
multif_p_reg_fit = exp(multif_p_reg_i):/(1:+exp(multif_p_reg_i))
onep_p_reg_fit = exp(onep_p_reg_i):/(1:+exp(onep_p_reg_i))
twop_p_reg_fit = exp(twop_p_reg_i):/(1:+exp(twop_p_reg_i))


for (j=1; j<=Regl; j++) {
alon_p_reg_ind = alon_p_reg_fit[(j-1)*TL+1..j*TL,.]:/J(TL, 1, alon_p_reg_fit[j*TL,.])
cple_p_reg_ind = cple_p_reg_fit[(j-1)*TL+1..j*TL,.]:/ J(TL, 1,cple_p_reg_fit[j*TL,.])
mult_p_reg_ind = mult_p_reg_fit[(j-1)*TL+1..j*TL,.]:/ J(TL, 1,mult_p_reg_fit[j*TL,.])
multif_p_reg_ind = multif_p_reg_fit[(j-1)*TL+1..j*TL,.]:/ J(TL, 1,multif_p_reg_fit[j*TL,.])
onep_p_reg_ind = onep_p_reg_fit[(j-1)*TL+1..j*TL,.]:/ J(TL, 1,onep_p_reg_fit[j*TL,.])
twop_p_reg_ind = twop_p_reg_fit[(j-1)*TL+1..j*TL,.]:/ J(TL, 1,twop_p_reg_fit[j*TL,.])
}

for (j=1; j<=Regl; j++) {
alon_p_reg_fit[(j-1)*TL+1..j*TL,.]=  (alon_p_reg_hist[(j-1)*TL+1..(j-1)*TL +HL,.]\alon_p_reg_ind[HL+1..rows(alon_p_reg_ind),.])
cple_p_reg_fit[(j-1)*TL+1..j*TL,.] =  (cple_p_reg_hist[(j-1)*TL+1..(j-1)*TL +HL,.]\cple_p_reg_ind[HL+1..rows(cple_p_reg_ind),.])
mult_p_reg_fit[(j-1)*TL+1..j*TL,.] =  (mult_p_reg_hist[(j-1)*TL+1..(j-1)*TL +HL,.]\mult_p_reg_ind[HL+1..rows(mult_p_reg_ind),.])
multif_p_reg_fit[(j-1)*TL+1..j*TL,.] =  (multif_p_reg_hist[(j-1)*TL+1..(j-1)*TL +HL,.]\multif_p_reg_ind[HL+1..rows(multif_p_reg_ind),.])
onep_p_reg_fit[(j-1)*TL+1..j*TL,.] = (onep_p_reg_hist[(j-1)*TL+1..(j-1)*TL +HL,.]\onep_p_reg_ind[HL+1..rows(onep_p_reg_ind),.])
twop_p_reg_fit[(j-1)*TL+1..j*TL,.] =  (twop_p_reg_hist[(j-1)*TL+1..(j-1)*TL +HL,.]\twop_p_reg_ind[HL+1..rows(twop_p_reg_ind),.])
}

for (j=1; j<=Regl; j++) {
	for (i=HL+1; i<=TL; i++) {
    alon_p_reg_fit[(j-1)*TL+i,.] = alon_p_reg_fit[(j-1)*TL+HL,.]:*alon_p_reg_ind[i,.]
    cple_p_reg_fit[(j-1)*TL+i,.] = cple_p_reg_fit[(j-1)*TL+HL,.]:*cple_p_reg_ind[i,.]
    mult_p_reg_fit[(j-1)*TL+i,.] = mult_p_reg_fit[(j-1)*TL+HL,.]:*mult_p_reg_ind[i,.]
    multif_p_reg_fit[(j-1)*TL+i,.] = multif_p_reg_fit[(j-1)*TL+HL,.]:*multif_p_reg_ind[i,.]
    onep_p_reg_fit[(j-1)*TL+i,.] = onep_p_reg_fit[(j-1)*TL+HL,.]:*onep_p_reg_ind[i,.]
    twop_p_reg_fit[(j-1)*TL+i,.] = twop_p_reg_fit[(j-1)*TL+HL,.]:*twop_p_reg_ind[i,.]
	}
}


/* (vi] Fill probability of no vehicle (1:-p(V=1]) */

/*(a)NZ Total*/
alon_p_fit[(HL+1)..rows(alon_p_fit),1] = 1:-alon_p_fit[(HL+1)..rows(alon_p_fit),2]
cple_p_fit[(HL+1)..rows(alon_p_fit),1] = 1:-cple_p_fit[(HL+1)..rows(alon_p_fit),2]
mult_p_fit[(HL+1).. rows(alon_p_fit),1] = 1:-mult_p_fit[(HL+1)..rows(alon_p_fit),2]
multif_p_fit[(HL+1).. rows(alon_p_fit),1] = 1:-multif_p_fit[(HL+1)..rows(alon_p_fit),2]
onep_p_fit[(HL+1).. rows(alon_p_fit),1] = 1:-onep_p_fit[(HL+1)..rows(alon_p_fit),2]
twop_p_fit[(HL+1).. rows(alon_p_fit),1] = 1:-twop_p_fit[(HL+1)..rows(alon_p_fit),2]

/*(b)Regional*/
for (j=1; j<=Regl; j++) {
alon_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,1] = 1:-alon_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,2]
cple_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,1] = 1:-cple_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,2]
mult_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,1] = 1:-mult_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,2]
multif_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,1] = 1:-multif_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,2]
onep_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,1] = 1:-onep_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,2]
twop_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,1] = 1:-twop_p_reg_fit[(j-1)*TL+(HL+1).. j*TL,2]
}

/* (vii] HH vehicle holdings by hh type and holding categories (0-3+)*/
/* Fitted values*/
/*(a) National*/

for (j=1; j<=TL; j++) {
    alon_veh_n_fit[j,1] = alon[j]:*alon_p_fit[j,1]
    alon_veh_n_fit[j,2] = alon[j]:*alon_p_fit[j,2]
    alon_veh_n_fit[j,3] = alon_veh_n_fit[j,2]:*alon_p_fit[j,3]
    alon_veh_n_fit[j,4] = alon_veh_n_fit[j,3]:*alon_p_fit[j,4]
    alon_veh_n_fit[j,3] = alon_veh_n_fit[j,3]-alon_veh_n_fit[j,4]
    alon_veh_n_fit[j,2] = alon_veh_n_fit[j,2] - (alon_veh_n_fit[j,3]+alon_veh_n_fit[j,4])
     
    cple_veh_n_fit[j,1] = cple[j]:*cple_p_fit[j,1]
    cple_veh_n_fit[j,2] = cple[j]:*cple_p_fit[j,2]
    cple_veh_n_fit[j,3] = cple_veh_n_fit[j,2]:*cple_p_fit[j,3]
    cple_veh_n_fit[j,4] = cple_veh_n_fit[j,3]:*cple_p_fit[j,4]
    cple_veh_n_fit[j,3] = cple_veh_n_fit[j,3]-cple_veh_n_fit[j,4]
    cple_veh_n_fit[j,2] = cple_veh_n_fit[j,2] - (cple_veh_n_fit[j,3]+cple_veh_n_fit[j,4])
      
    multi_veh_n_fit[j,1] = multi[j]:*mult_p_fit[j,1]
    multi_veh_n_fit[j,2] = multi[j]:*mult_p_fit[j,2]
    multi_veh_n_fit[j,3] = multi_veh_n_fit[j,2]:*mult_p_fit[j,3]
    multi_veh_n_fit[j,4] = multi_veh_n_fit[j,3]:*mult_p_fit[j,4]
    multi_veh_n_fit[j,3] = multi_veh_n_fit[j,3]-multi_veh_n_fit[j,4]
    multi_veh_n_fit[j,2] = multi_veh_n_fit[j,2] - (multi_veh_n_fit[j,3]+multi_veh_n_fit[j,4])
    
    multif_veh_n_fit[j,1] = multif[j]:*multif_p_fit[j,1]
    multif_veh_n_fit[j,2] = multif[j]:*multif_p_fit[j,2]
    multif_veh_n_fit[j,3] = multif_veh_n_fit[j,2]:*multif_p_fit[j,3]
    multif_veh_n_fit[j,4] = multif_veh_n_fit[j,3]:*multif_p_fit[j,4]
    multif_veh_n_fit[j,3] = multif_veh_n_fit[j,3]-multif_veh_n_fit[j,4]
    multif_veh_n_fit[j,2] = multif_veh_n_fit[j,2] - (multif_veh_n_fit[j,3]+multif_veh_n_fit[j,4])
    
    onep_veh_n_fit[j,1] = onep[j]:*onep_p_fit[j,1]
    onep_veh_n_fit[j,2] = onep[j]:*onep_p_fit[j,2]
    onep_veh_n_fit[j,3] = onep_veh_n_fit[j,2]:*onep_p_fit[j,3]
    onep_veh_n_fit[j,4] = onep_veh_n_fit[j,3]:*onep_p_fit[j,4]
    onep_veh_n_fit[j,3] = onep_veh_n_fit[j,3]-onep_veh_n_fit[j,4]
    onep_veh_n_fit[j,2] = onep_veh_n_fit[j,2] - (onep_veh_n_fit[j,3]+onep_veh_n_fit[j,4])
    
    twop_veh_n_fit[j,1] = twop[j]:*twop_p_fit[j,1]
    twop_veh_n_fit[j,2] = twop[j]:*twop_p_fit[j,2]
    twop_veh_n_fit[j,3] = twop_veh_n_fit[j,2]:*twop_p_fit[j,3]
    twop_veh_n_fit[j,4] = twop_veh_n_fit[j,3]:*twop_p_fit[j,4]
    twop_veh_n_fit[j,3] = twop_veh_n_fit[j,3]-twop_veh_n_fit[j,4]
    twop_veh_n_fit[j,2] = twop_veh_n_fit[j,2] - (twop_veh_n_fit[j,3]+twop_veh_n_fit[j,4])
      
}

/*(b) Regional*/



for (i=1; i<=Regl; i++) {
    for (j=1; j<=TL; j++) {
    alon_veh_reg_n_fit[(i-1)*TL+j,1] = alon_reg[j,i]:*alon_p_reg_fit[(i-1)*TL+j,1]
    alon_veh_reg_n_fit[(i-1)*TL+j,2] = alon_reg[j,i]:*alon_p_reg_fit[(i-1)*TL+j,2]
    alon_veh_reg_n_fit[(i-1)*TL+j,3] = alon_veh_reg_n_fit[(i-1)*TL+j,2]:*alon_p_reg_fit[(i-1)*TL+j,3]
    alon_veh_reg_n_fit[(i-1)*TL+j,4] = alon_veh_reg_n_fit[(i-1)*TL+j,3]:*alon_p_reg_fit[(i-1)*TL+j,4]
    alon_veh_reg_n_fit[(i-1)*TL+j,3] = alon_veh_reg_n_fit[(i-1)*TL+j,3]-alon_veh_reg_n_fit[(i-1)*TL+j,4]
    alon_veh_reg_n_fit[(i-1)*TL+j,2] = alon_veh_reg_n_fit[(i-1)*TL+j,2]-(alon_veh_reg_n_fit[(i-1)*TL+j,3]+alon_veh_reg_n_fit[(i-1)*TL+j,4])
    cple_veh_reg_n_fit[(i-1)*TL+j,1] = cple_reg[j,i]:*cple_p_reg_fit[j,1]
    cple_veh_reg_n_fit[(i-1)*TL+j,2] = cple_reg[j,i]:*cple_p_reg_fit[(i-1)*TL+j,2]
    cple_veh_reg_n_fit[(i-1)*TL+j,3] = cple_veh_reg_n_fit[(i-1)*TL+j,2]:*cple_p_reg_fit[(i-1)*TL+j,3]
    cple_veh_reg_n_fit[(i-1)*TL+j,4] = cple_veh_reg_n_fit[(i-1)*TL+j,3]:*cple_p_reg_fit[(i-1)*TL+j,4]
    cple_veh_reg_n_fit[(i-1)*TL+j,3] = cple_veh_reg_n_fit[(i-1)*TL+j,3]-cple_veh_reg_n_fit[(i-1)*TL+j,4]
    cple_veh_reg_n_fit[(i-1)*TL+j,2] = cple_veh_reg_n_fit[(i-1)*TL+j,2]-(cple_veh_reg_n_fit[(i-1)*TL+j,3]+cple_veh_reg_n_fit[(i-1)*TL+j,4])
      
    multi_veh_reg_n_fit[(i-1)*TL+j,1] = multi_reg[j,i]:*mult_p_reg_fit[j,1]
    multi_veh_reg_n_fit[(i-1)*TL+j,2] = multi_reg[j,i]:*mult_p_reg_fit[(i-1)*TL+j,2]
    multi_veh_reg_n_fit[(i-1)*TL+j,3] = multi_veh_reg_n_fit[(i-1)*TL+j,2]:*mult_p_reg_fit[(i-1)*TL+j,3]
    multi_veh_reg_n_fit[(i-1)*TL+j,4] = multi_veh_reg_n_fit[(i-1)*TL+j,3]:*mult_p_reg_fit[(i-1)*TL+j,4]
    multi_veh_reg_n_fit[(i-1)*TL+j,3] = multi_veh_reg_n_fit[(i-1)*TL+j,3]-multi_veh_reg_n_fit[(i-1)*TL+j,4]
    multi_veh_reg_n_fit[(i-1)*TL+j,2] = multi_veh_reg_n_fit[(i-1)*TL+j,2]-(multi_veh_reg_n_fit[(i-1)*TL+j,3]+multi_veh_reg_n_fit[(i-1)*TL+j,4])
    
    multif_veh_reg_n_fit[(i-1)*TL+j,1] = multif_reg[j,i]:*multif_p_reg_fit[j,1]
    multif_veh_reg_n_fit[(i-1)*TL+j,2] = multif_reg[j,i]:*multif_p_reg_fit[(i-1)*TL+j,2]
    multif_veh_reg_n_fit[(i-1)*TL+j,3] = multif_veh_reg_n_fit[(i-1)*TL+j,2]:*multif_p_reg_fit[(i-1)*TL+j,3]
    multif_veh_reg_n_fit[(i-1)*TL+j,4] = multif_veh_reg_n_fit[(i-1)*TL+j,3]:*multif_p_reg_fit[(i-1)*TL+j,4]
    multif_veh_reg_n_fit[(i-1)*TL+j,3] = multif_veh_reg_n_fit[(i-1)*TL+j,3]-multif_veh_reg_n_fit[(i-1)*TL+j,4]
    multif_veh_reg_n_fit[(i-1)*TL+j,2] = multif_veh_reg_n_fit[(i-1)*TL+j,2]-(multif_veh_reg_n_fit[(i-1)*TL+j,3]+multif_veh_reg_n_fit[(i-1)*TL+j,4])
    
    onep_veh_reg_n_fit[(i-1)*TL+j,1] = onep_reg[j,i]:*onep_p_reg_fit[j,1]
    onep_veh_reg_n_fit[(i-1)*TL+j,2] = onep_reg[j,i]:*onep_p_reg_fit[(i-1)*TL+j,2]
    onep_veh_reg_n_fit[(i-1)*TL+j,3] = onep_veh_reg_n_fit[(i-1)*TL+j,2]:*onep_p_reg_fit[(i-1)*TL+j,3]
    onep_veh_reg_n_fit[(i-1)*TL+j,4] = onep_veh_reg_n_fit[(i-1)*TL+j,3]:*onep_p_reg_fit[(i-1)*TL+j,4]
    onep_veh_reg_n_fit[(i-1)*TL+j,3] = onep_veh_reg_n_fit[(i-1)*TL+j,3]-onep_veh_reg_n_fit[(i-1)*TL+j,4]
    onep_veh_reg_n_fit[(i-1)*TL+j,2] = onep_veh_reg_n_fit[(i-1)*TL+j,2]-(onep_veh_reg_n_fit[(i-1)*TL+j,3]+onep_veh_reg_n_fit[(i-1)*TL+j,4])
    
    twop_veh_reg_n_fit[(i-1)*TL+j,1] = twop_reg[j,i]:*twop_p_reg_fit[j,1]
    twop_veh_reg_n_fit[(i-1)*TL+j,2] = twop_reg[j,i]:*twop_p_reg_fit[(i-1)*TL+j,2]
    twop_veh_reg_n_fit[(i-1)*TL+j,3] = twop_veh_reg_n_fit[(i-1)*TL+j,2]:*twop_p_reg_fit[(i-1)*TL+j,3]
    twop_veh_reg_n_fit[(i-1)*TL+j,4] = twop_veh_reg_n_fit[(i-1)*TL+j,3]:*twop_p_reg_fit[(i-1)*TL+j,4]
    twop_veh_reg_n_fit[(i-1)*TL+j,3] = twop_veh_reg_n_fit[(i-1)*TL+j,3]-twop_veh_reg_n_fit[(i-1)*TL+j,4]
    twop_veh_reg_n_fit[(i-1)*TL+j,2] = twop_veh_reg_n_fit[(i-1)*TL+j,2]-(twop_veh_reg_n_fit[(i-1)*TL+j,3]+twop_veh_reg_n_fit[(i-1)*TL+j,4])
}
}


/*This step smooths the connection between history and model -- applying*/
/*only to the regional model becasue that is the model of real interest*/

/*(a) NZ Total [identity) */
alon_veh_n = alon_veh_n_fit
cple_veh_n = cple_veh_n_fit 
multi_veh_n = multi_veh_n_fit
multif_veh_n = multif_veh_n_fit
onep_veh_n = onep_veh_n_fit
twop_veh_n = twop_veh_n_fit

/*(b) Regional*/
alon_veh_reg_fit_growth = J(TL*Regl,4,0)
cple_veh_reg_fit_growth = J(TL*Regl,4,0)
multi_veh_reg_fit_growth = J(TL*Regl,4,0)
multif_veh_reg_fit_growth = J(TL*Regl,4,0)
onep_veh_reg_fit_growth = J(TL*Regl,4,0)
twop_veh_reg_fit_growth = J(TL*Regl,4,0)


for (j=1; j<=Regl; j++) {
alon_veh_reg_fit_growth[(j-1)*TL+1,.] = J(1,cols(alon_veh_reg_fit_growth),0)
alon_veh_reg_fit_growth[(j-1)*TL+2..j*TL,.] = diff(alon_veh_reg_n_fit[(j-1)*TL+1..j*TL,.]):/alon_veh_reg_n_fit[(j-1)*TL+1..j*TL-1,.]

alon_veh_reg_n[(j-1)*TL+HL+1..j*TL,.] = alon_veh_reg_n[(j-1)*TL+HL..j*TL-1,.]:+(1:+alon_veh_reg_fit_growth[(j-1)*TL+(HL+1)..j*TL,.])

cple_veh_reg_fit_growth[(j-1)*TL+2..j*TL,.] = diff(cple_veh_reg_n_fit[(j-1)*TL+1..j*TL,.]):/cple_veh_reg_n_fit[(j-1)*TL+1..j*TL-1,.]

cple_veh_reg_n[(j-1)*TL+HL+1..j*TL,.] = cple_veh_reg_n[(j-1)*TL+HL..j*TL-1,.]:*(1:+cple_veh_reg_fit_growth[(j-1)*TL+(HL+1)..j*TL,.])

multi_veh_reg_fit_growth[(j-1)*TL+2..j*TL,.] = diff(multi_veh_reg_n_fit[(j-1)*TL+1..j*TL,.]):/multi_veh_reg_n_fit[(j-1)*TL+1..j*TL-1,.]
multi_veh_reg_n[(j-1)*TL+(HL+1)..j*TL,.] = multi_veh_reg_n[(j-1)*TL+HL..j*TL-1,.]:*(1:+multi_veh_reg_fit_growth[(j-1)*TL+(HL+1)..j*TL,.])


multif_veh_reg_fit_growth[(j-1)*TL+2..j*TL,.] = diff(multif_veh_reg_n_fit[(j-1)*TL+1..j*TL,.]):/multif_veh_reg_n_fit[(j-1)*TL+1..j*TL-1,.]
multif_veh_reg_n[(j-1)*TL+(HL+1)..j*TL,.] = multif_veh_reg_n[(j-1)*TL+HL..j*TL-1,.]:*(1:+multif_veh_reg_fit_growth[(j-1)*TL+(HL+1)..j*TL,.])

onep_veh_reg_fit_growth[(j-1)*TL+2..j*TL,.] = diff(onep_veh_reg_n_fit[(j-1)*TL+1..j*TL,.]):/onep_veh_reg_n_fit[(j-1)*TL+1..j*TL-1,.]
onep_veh_reg_n[(j-1)*TL+(HL+1)..j*TL,.] = onep_veh_reg_n[(j-1)*TL+HL..j*TL-1,.]:*(1:+onep_veh_reg_fit_growth[(j-1)*TL+(HL+1)..j*TL,.])

twop_veh_reg_fit_growth[(j-1)*TL+2..j*TL,.] = diff(twop_veh_reg_n_fit[(j-1)*TL+1..j*TL,.]):/twop_veh_reg_n_fit[(j-1)*TL+1..j*TL-1,.]
twop_veh_reg_n[(j-1)*TL+(HL+1)..j*TL,.] = twop_veh_reg_n[(j-1)*TL+HL..j*TL-1,.]:*(1:+twop_veh_reg_fit_growth[(j-1)*TL+(HL+1)..j*TL,.])
}


for (i=HL+1; i<=TL; i++) { 
    for (j=1; j<=Regl; j++) {
    alon_veh_reg_n[(j-1)*TL+i,.] = alon_veh_reg_n[(j-1)*TL+i-1,.]:*(1:+alon_veh_reg_fit_growth[(j-1)*TL+i,.])
    cple_veh_reg_n[(j-1)*TL+i,.]  = cple_veh_reg_n[(j-1)*TL+i-1,.]:*(1:+cple_veh_reg_fit_growth[(j-1)*TL+i,.] )

    multi_veh_reg_n[(j-1)*TL+i,.]  = multi_veh_reg_n[(j-1)*TL+i-1,.]:*(1:+multi_veh_reg_fit_growth[(j-1)*TL+i,.] )
    multif_veh_reg_n[(j-1)*TL+i,.]  = multif_veh_reg_n[(j-1)*TL+i-1,.]:*(1:+multif_veh_reg_fit_growth[(j-1)*TL+i,.] )
    onep_veh_reg_n[(j-1)*TL+i,.]  = onep_veh_reg_n[(j-1)*TL+i-1,.]:*(1:+onep_veh_reg_fit_growth[(j-1)*TL+i,.] )
    twop_veh_reg_n[(j-1)*TL+i,.]  = twop_veh_reg_n[(j-1)*TL+i-1,.]:*(1:+twop_veh_reg_fit_growth[(j-1)*TL+i,.] )
  }
}


/* (viii] Number of vehicles by household type*/
/*(a) NZ Total*/
alon_veh = alon_veh_n*veh_per_hh'
cple_veh = cple_veh_n*veh_per_hh'
multi_veh = multi_veh_n*veh_per_hh'
multif_veh = multif_veh_n*veh_per_hh'
onep_veh = onep_veh_n*veh_per_hh'
twop_veh = twop_veh_n*veh_per_hh'

/*(b) Regional*/
for (i=1; i<=Regl; i++) {
alon_veh_reg[.,i] = alon_veh_reg_n[(i-1)*TL+1..i*TL,.]*veh_per_hh_reg[(i-1)*4+1..i*4]
cple_veh_reg[.,i]= cple_veh_reg_n[(i-1)*TL+1..i*TL,.]*veh_per_hh_reg[(i-1)*4+1..i*4]
multi_veh_reg[.,i]= multi_veh_reg_n[(i-1)*TL+1..i*TL,.]*veh_per_hh_reg[(i-1)*4+1..i*4]
multif_veh_reg[.,i]= multif_veh_reg_n[(i-1)*TL+1..i*TL,.]*veh_per_hh_reg[(i-1)*4+1..i*4]
onep_veh_reg[.,i]= onep_veh_reg_n[(i-1)*TL+1..i*TL,.]*veh_per_hh_reg[(i-1)*4+1..i*4]
twop_veh_reg[.,i]= twop_veh_reg_n[(i-1)*TL+1..i*TL,.]*veh_per_hh_reg[(i-1)*4+1..i*4]
}


/* [ix) Total vehicle holdings by HH*/
/*(a) NZ Totals*/
veh = alon_veh + cple_veh + multi_veh + multif_veh + onep_veh + twop_veh
veh_by_hh_type = (alon_veh,onep_veh,twop_veh,multif_veh,multi_veh,cple_veh)
veh_per_hh_by_hh_type = veh_by_hh_type:/hh_composition
vehicles_per_hh = veh:/households
vehicles_per_pop = veh:/pop


/*(b) Regional*/
veh_reg_by_hh_type = (alon_veh_reg,cple_veh_reg,multi_veh_reg,multif_veh_reg,onep_veh_reg,twop_veh_reg)
veh_reg = J(TL,Regl,0)
for (i=1; i<=Regl; i++) {
	veh_reg[.,i] = rowsum(veh_reg_by_hh_type[.,(i-1)*j_h+1..i*j_h])
}
veh_per_pop_by_reg = veh_reg:/pop_by_reg
/*veh_reg_nzl = rowsum(veh_reg)*/
veh_reg_nzl = rowsum(veh_reg)
veh_reg_nzl_per_pop = veh_reg_nzl:/pop
veh_demand_growth = J(TL,1,0)
veh_demand_growth[2..rows(veh_demand_growth)]= diff(veh_reg_nzl):/veh_reg_nzl[1..Time_length-1]


/*Check HH aggregates*/
/* THIS NEED REVISION- SUMS DONT ADD UP */
veh_reg_n_all = (alon_veh_reg_n,cple_veh_reg_n,multi_veh_reg_n,multif_veh_reg_n,onep_veh_reg_n,twop_veh_reg_n)
veh_reg_n_sum = J(TL,1,0)
for (i=1; i<=Regl; i++) {
veh_reg_n_sum[i] = colsum(rowsum(veh_reg_n_all[(i-1)*TL+1..i*TL,.]))
}

end

/* The series need further investigation! particularly the shape of veh_tot below (this is chiefly driven by population projections)
getmata (alone1 alone2 alone3 alone4 couple1 couple2 couple3 couple4 multi1 multi2 multi3 multi4 multif1 multif2 multif3 multif4 onep1 onep2 onep3 onep4 twop1 twop2 twop3 twop4) = veh_reg_n_all, replace
gen year = 1992 + mod(_n-1,59)
bys year: gen iden = _n
sort iden year
g Region = "."


local i = 1
foreach reg in "nor" "akl" "wai" "bop" "tar" "man" "wel" "can" "otg" "sth" "gis" "usi"{
	replace Region = "`reg'" if iden == `i'
	local i = `i' +1
}
encode Region, g(reg)
xtset reg year
tsline alone1 if reg ==2
xtline alone1
egen veh_reg_tot = rowtotal(alone1 alone2 alone3 alone4 couple1 couple2 couple3 couple4 multi1 multi2 multi3 multi4 multif1 multif2 multif3 multif4 onep1 onep2 onep3 onep4 twop1 twop2 twop3 twop4)
xtline veh_reg_tot
bys year: egen veh_tot= total(veh_reg_tot)
tsline veh_tot
*/